function transliterate(text){
	let table = {
		// global
		'Ґ'  : 'G', 'ґ'  : 'g', 'Є'  : 'Ie', 'є'  : 'ie', 'І'  : 'I', 'і'  : 'i', 'Ї'  : 'I', 'ї'  : 'i', 'Ї' : 'i', 'ї' : 'i', 'Ё' : 'Jo', 'ё' : 'jo', 'й' : 'i', 'Й' : 'I',
		//greek
		'α' : 'a', 'β' : 'v', 'γ' : 'g', 'δ' : 'd', 'ε' : 'e', 'ζ' : 'z', 'η' : 'i', 'ι' : 'i', 'κ' : 'k', 'λ' : 'l', 'μ' : 'm', 'ν' : 'n', 'ξ' : 'x', 'ο' : 'o', 'π' : 'p', 'ρ' : 'r', 'σ' : 's', 'τ' : 't', 'υ' : 'y', 'φ' : 'f', 'ω' : 'o', 'ά' : 'a', 'ί' : 'i', 'ύ' : 'y', 'έ' : 'e', 'ό' : 'o', 'ή' : 'i', 'ώ' : 'o', 'ϊ' : 'i', 'ϋ' : 'e', 'ΐ' : 'i', 'ΰ' : 'y', 'ς' : 's', 'Α' : 'A', 'Β' : 'V', 'Γ' : 'G', 'Δ' : 'D', 'Ε' : 'E', 'Ζ' : 'Z', 'Η' : 'I', 'Ι' : 'I', 'Κ' : 'K', 'Λ' : 'L', 'Μ' : 'M', 'Ν' : 'N', 'Ξ' : 'X', 'Ο' : 'O', 'Π' : 'P', 'Ρ' : 'R', 'Σ' : 'S', 'Τ' : 'T', 'Υ' : 'Y', 'Φ' : 'F', 'Ω' : 'O', 'Ά' : 'Α', 'Ί' : 'I', 'Ύ' : 'Y', 'Έ' : 'E', 'Ό' : 'O', 'Ή' : 'I', 'Ώ' : 'O', 'Ϊ' : 'I', 'Ϋ' : 'Y',
		//romanian
		'ă' : 'a', 'Ă' : 'A', 'â' : 'a', 'Â' : 'A', 'î' : 'i', 'Î' : 'I', 'ş' : 's', 'Ş' : 'S', 'ţ' : 't', 'Ţ' : 'T',
		// russian
		'А'  : 'A', 'а'  : 'a', 'Б'  : 'B', 'б'  : 'b', 'В'  : 'V', 'в'  : 'v', 'Г'  : 'G', 'г'  : 'g', 'Д'  : 'D', 'д'  : 'd', 'Е'  : 'E', 'е'  : 'e', 'Ё'  : 'Jo', 'ё'  : 'jo', 'Ж'  : 'Zh', 'ж'  : 'zh', 'З'  : 'Z', 'з'  : 'z', 'И'  : 'I', 'и'  : 'i', 'Й'  : 'J', 'й'  : 'j', 'К'  : 'K', 'к'  : 'k', 'Л'  : 'L', 'л'  : 'l', 'М'  : 'M', 'м'  : 'm', 'Н'  : 'N', 'н'  : 'n', 'О'  : 'O', 'о'  : 'o', 'П'  : 'P', 'п'  : 'p', 'Р'  : 'R', 'р'  : 'r', 'С'  : 'S', 'с'  : 's', 'Т'  : 'T', 'т'  : 't', 'У'  : 'U', 'у'  : 'u', 'Ф'  : 'F', 'ф'  : 'f', 'Х'  : 'H', 'х'  : 'h', 'Ц'  : 'C', 'ц'  : 'c', 'Ч'  : 'Ch', 'ч'  : 'ch', 'Ш'  : 'Sh', 'ш'  : 'sh', 'Щ'  : 'Shh', 'щ'  : 'shh', 'Ъ'  : '', 'ъ'  : '', 'Ы'  : 'Y', 'ы'  : 'y', 'Ь'  : '', 'ь'  : '', 'Э'  : 'Je', 'э'  : 'je', 'Ю'  : 'Ju', 'ю'  : 'ju', 'Я'  : 'Ja', 'я'  : 'ja',
		// ukrainian
		'Г'  : 'H', 'г' : 'h', 'И' : 'Y', 'и' : 'y', 'Х' : 'Kh', 'х' : 'kh', 'Ц' : 'Ts', 'ц' : 'ts', 'Щ' : 'Shch', 'щ' : 'shch', 'Ю' : 'Iu', 'ю' : 'iu', 'Я' : 'Ia', 'я' : 'ia',
		//bulgarian
		'Щ'  : 'Sht', 'щ' : 'sht', 'Ъ' : 'a', 'ъ' : 'a',
		//georgian
		'ა'  : 'a', 'ბ' : 'b', 'გ' : 'g', 'დ' : 'd', 'ე' : 'e', 'ვ' : 'v', 'ზ' : 'z', 'თ' : 'th', 'ი' : 'i', 'კ' : 'k', 'ლ' : 'l', 'მ' : 'm', 'ნ' : 'n', 'ო' : 'o', 'პ' : 'p', 'ჟ' : 'zh', 'რ' : 'r', 'ს' : 's', 'ტ' : 't', 'უ' : 'u', 'ფ' : 'ph', 'ქ' : 'q', 'ღ' : 'gh', 'ყ' : 'qh', 'შ' : 'sh', 'ჩ' : 'ch', 'ც' : 'ts', 'ძ' : 'dz', 'წ' : 'ts', 'ჭ' : 'tch', 'ხ' : 'kh', 'ჯ' : 'j', 'ჰ' : 'h',
		// Armenian
		'Ա'  : 'A', 'ա'  : 'a', 'Բ'  : 'B', 'բ'  : 'b', 'Գ'  : 'G', 'գ'  : 'g', 'Դ'  : 'D', 'դ'  : 'd', ' Ե' : ' Ye', 'Ե'  : 'E', ' ե' : ' ye', 'ե'  : 'e', 'Զ'  : 'Z', 'զ'  : 'z', 'Է'  : 'E', 'է'  : 'e', 'Ը'  : 'Y', 'ը'  : 'y', 'Թ'  : 'T', 'թ'  : 't', 'Ժ'  : 'Zh', 'ժ'  : 'zh', 'Ի'  : 'I', 'ի'  : 'i', 'Լ'  : 'L', 'լ'  : 'l', 'Խ'  : 'KH', 'խ'  : 'kh', 'Ծ'  : 'TS', 'ծ'  : 'ts', 'Կ'  : 'K', 'կ'  : 'K', 'Հ'  : 'H', 'հ'  : 'h', 'Ձ'  : 'DZ', 'ձ'  : 'dz', 'Ղ'  : 'GH', 'ղ'  : 'gh', 'Ճ'  : 'J', 'Ճ'  : 'j', 'Մ'  : 'M', 'մ'  : 'm', 'Յ'  : 'Y', 'յ'  : 'y', 'Ն'  : 'N', 'ն'  : 'n', 'Շ'  : 'SH', 'շ'  : 'sh', ' Ո' : 'VO', 'Ո'  : 'VO', ' ո' : ' vo', 'ո'  : 'o', 'Չ'  : 'Ch', 'չ'  : 'ch', 'Պ'  : 'P', 'պ'  : 'p', 'Ջ'  : 'J', 'ջ'  : 'j', 'Ռ'  : 'R', 'ռ'  : 'r', 'Ս'  : 'S', 'ս'  : 's', 'Վ'  : 'V', 'վ'  : 'v', 'Տ'  : 'T', 'տ'  : 't', 'Ր'  : 'R', 'ր'  : 'r', 'Ց'  : 'C', 'ց'  : 'c', 'Ու' : 'U', 'ու' : 'u', 'Փ'  : 'P', 'փ'  : 'p', 'Ք'  : 'Q', 'ք'  : 'q', 'Եվ' : 'EV', 'և'  : 'ev', 'Օ'  : 'O', 'օ'  : 'o', 'Ֆ'  : 'F', 'ֆ'  : 'f',
		// Serbian
		'Ђ'  : 'DJ', 'Ж'  : 'Z', 'З'  : 'Z', 'Љ'  : 'LJ', 'Њ'  : 'NJ', 'Ш'  : 'S', 'Ћ'  : 'C', 'Ц'  : 'C', 'Ч'  : 'C', 'Џ'  : 'DZ', 'ђ'  : 'dj', 'ж'  : 'z', 'з'  : 'z', 'и'  : 'i', 'љ'  : 'lj', 'њ'  : 'nj', 'ш'  : 's', 'ћ'  : 'c', 'ч'  : 'c', 'џ'  : 'dz', 'Ња' : 'Nja', 'Ње' : 'Nje', 'Њи' : 'Nji', 'Њо' : 'Njo', 'Њу' : 'Nju', 'Ља' : 'Lja', 'Ље' : 'Lje', 'Љи' : 'Lji', 'Љо' : 'Ljo', 'Љу' : 'Lju', 'Џа' : 'Dza', 'Џе' : 'Dze', 'Џи' : 'Dzi', 'Џо' : 'Dzo', 'Џу' : 'Dzu',
	};

  return text.split('').map(function (char) { 
    return table[char] || char; 
  }).join("");
}


function slugify(str) {
	if (str) {	
		return transliterate(str)
			.replace(/([^\w]+|\s+)/g, '-') // Replace space and other characters by hyphen
			.replace(/\-\-+/g, '-')	// Replaces multiple hyphens by one hyphen
			.replace(/(^-+|-+$)/g, '') // Remove extra hyphens from beginning or end of the string
			.toLowerCase();
	}
	
	return str;
}
/*
document.addEventListener("content.slug", (e) => {
	e.detail.slug = transliterateSlugify(transliterate(e.detail.text));
});
*/
